﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;
using PostitCore;
using PostitCommon;
using Newtonsoft.Json;

namespace DeXGets
{
    public class CurrentGroupMemberships : BaseClass
    {
        public class CurrentGroupMemberships_Response
        {
            public Guid ExternalID;
            public Nullable<DateTime> StartDate;
            public Nullable<DateTime> EndDate;
            public BaseLookups PastoralGroup;
            public BaseLookups Member;
        }
        public Dictionary<Guid, CurrentGroupMemberships_Response> GetValues(string token, string key, HttpClient httpClient, Guid GroupID)
        {
            Dictionary<Guid, CurrentGroupMemberships_Response> values = new Dictionary<Guid, CurrentGroupMemberships_Response>();
            string URL_ContactDetails = SetURL("PastoralGroup", string.Format("PastoralGroupMemberships?$filter=PastoralGroup/ExternalID eq {0}",GroupID));
            string resp = DoCall(URL_ContactDetails, token, httpClient, key);
            ODataResponse<CurrentGroupMemberships_Response> contacts = null;
            try
            {
                contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<CurrentGroupMemberships_Response>>(resp);
                foreach (CurrentGroupMemberships_Response ar in contacts.Value)
                {
                    if ((ar.StartDate == null || ar.StartDate <= DateTime.Today)
                            && (ar.EndDate == null || ar.EndDate >= DateTime.Today))
                    {
                        values.Add(ar.ExternalID, ar);
                    }
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(contacts.NextLink))
                {
                    resp = DoCall(GetNextLink(contacts.NextLink), token, httpClient, key);
                    contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<CurrentGroupMemberships_Response>>(resp);
                    foreach (CurrentGroupMemberships_Response ar in contacts.Value)
                    {
                        if ((ar.StartDate == null || ar.StartDate <= DateTime.Today)
                                && (ar.EndDate == null || ar.EndDate >= DateTime.Today))
                        {
                            values.Add(ar.ExternalID, ar);
                        }
                    }
                }
            }
            catch
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}
